public class Elevator
{
	private Door door;
	private Scales scales;
	private Person person;

	private int floor;

	public Elevator()
	{
		door = new Door();
		scales = new Scales();
	}

	public void addLoad(Person person)
	{
		setPerson(person);
		scales.weigh(person.getWeight());
	}

	public void move(int floor) throws LoadTooHeavyException
	{
		if (scales.isLoadTooHeavy())
		{
			throw new LoadTooHeavyException();
		}

		setFloor(floor);
	}	

	public void openDoor()
	{
		door.setOpen(Door.OPENED);
	}

	public void closeDoor()
	{
		door.setOpen(Door.CLOSED);
	}

	public Door getDoor()
	{
		return this.door;
	}

	public void setDoor(Door door)
	{
		this.door = door;
	}

	public Person getPerson()
	{
		return this.person;
	}

	public void setPerson(Person Person)
	{
		this.person = person;
	}

	public void setFloor(int floor)
	{
		this.floor = floor;
	}

	public int getFloor()
	{
		return this.floor;
	}
	

	public String toString()
	{
		return "Door: " + door;
	}
}
